
<!doctype html>
<html class="no-js" lang="">

<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<title><?php echo e($settings->school_name); ?></title>
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- Favicon -->
	<link rel="shortcut icon" type="image/x-icon" href="<?php echo e($settings->favicon ? asset('uploads/'.$settings->favicon) : asset('uploads/no_image.jpg')); ?>">
	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="<?php echo e(asset('auth_assets/css/bootstrap.min.css')); ?>">
	<!-- Fontawesome CSS -->
	<link rel="stylesheet" href="<?php echo e(asset('auth_assets/css/fontawesome-all.min.css')); ?>">
	<!-- Flaticon CSS -->
	<link rel="stylesheet" href="<?php echo e(asset('auth_assets/font/flaticon.css')); ?>">
	<!-- Star Animation CSS -->
	<link rel="stylesheet" href="<?php echo e(asset('auth_assets/css/star-animation.css')); ?>">
	<!-- Google Web Fonts -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700&display=swap" rel="stylesheet">
	<!-- Custom CSS -->
	<link rel="stylesheet" href="<?php echo e(asset('auth_assets/style.css')); ?>">
</head>

<body class="overflow-hidden">
	<!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    
    
	<section class="fxt-template-layout22" data-bg-image="<?php echo e(asset('auth_assets/img/figure/bg22-laa.jpg')); ?>">
		<!-- Star Animation Start Here -->
		<div class="star-animation">
			<div id="stars1"></div>
			<div id="stars2"></div>
			<div id="stars3"></div>
			<div id="stars4"></div>
			<div id="stars5"></div>
		</div>
		<!-- Star Animation End Here -->
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-7 col-12 fxt-none-991">
					<div class="fxt-header">
						
					</div>
				</div>
				<div class="col-lg-5 col-12 fxt-bg-color">
					<div class="fxt-content">
                        <div class="fxt-transformY-50 fxt-transition-delay-1 text-center mb-3">
							<img src="<?php echo e($settings->logo ? asset('uploads/'.$settings->logo) : asset('uploads/no_image.jpg')); ?>" alt="Logo" style="max-height: 100px">
						</div>
						<div class="fxt-form">
							<h3 class="mb-1"><?php echo e($settings->school_name); ?></h3>
							
							<p>Login into your pages account</p>
							<form method="POST" action="<?php echo e(route('login')); ?>">
                                <?php echo csrf_field(); ?>
								<div class="form-group mb-2">
									<label for="email" class="input-label">Email Address</label>
									<input type="email" id="email" class="form-control" name="email" placeholder="demo@gmail.com" required="required" <?php if(Cookie::has('email')): ?> value="<?php echo e(Cookie::get('email')); ?>" <?php endif; ?>>
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
								</div>
								<div class="form-group">
									<label for="password" class="input-label">Password</label>
									<input id="password" type="password" class="form-control" name="password" placeholder="********" required="required" <?php if(Cookie::has('password')): ?> value="<?php echo e(Cookie::get('password')); ?>" <?php endif; ?>>
									<i toggle="#password" class="fa fa-fw fa-eye toggle-password field-icon"></i>
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
								</div>
								<div class="form-group">
									<div class="fxt-checkbox-area">
										<div class="checkbox">
											<input id="checkbox1" type="checkbox" name="remember_me" <?php if(Cookie::has('email')): ?> checked <?php endif; ?>>
											<label for="checkbox1">Keep me logged in</label>
										</div>
										
									</div>
								</div>
								<div class="form-group">
									<button type="submit" class="fxt-btn-fill">Log in</button>
								</div>
							</form>
						</div>
						
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- jquery-->
	<script src="<?php echo e(asset('auth_assets/js/jquery-3.5.0.min.js')); ?>"></script>
	<!-- Bootstrap js -->
	<script src="<?php echo e(asset('auth_assets/js/bootstrap.min.js')); ?>"></script>
	<!-- Imagesloaded js -->
	<script src="<?php echo e(asset('auth_assets/js/imagesloaded.pkgd.min.js')); ?>"></script>
	<!-- Validator js -->
	<script src="<?php echo e(asset('auth_assets/js/validator.min.js')); ?>"></script>
	<!-- Custom Js -->
	<script src="<?php echo e(asset('auth_assets/js/main.js')); ?>"></script>

</body>

</html><?php /**PATH C:\xampp\htdocs\erp_software\resources\views/auth/login.blade.php ENDPATH**/ ?>